
// Copyright  2002-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_NEUROSIS_H_
#define _NEUROSIS_ENGINE_NEUROSIS_H_

/***************************************************************************/

#pragma warning(disable:4100)													// "unreferenced formal parameter" (openAL)
#pragma warning(disable:4238)													// "nonstandard extension used"
#pragma warning(disable:4701)													// "local variable not initialized" (openAL)
#pragma warning(disable:4702)													// "unreachable code"

/***************************************************************************/

//#include <afxwin.h>																		// Instead of <windows.h> to allow for MFC compatibility
#include <windows.h>																	// Windows
#include <gl\gl.h>																		// OpenGL
#include <gl\glu.h>																		// OpenGL
#include <assert.h>																		// --> Assert()
#include <atlstr.h>																		// --> CString
#include <list>																				// --> std::list
#include <math.h>																			// Math
#include <mmsystem.h>																	// Multimedia
#include <process.h>																	// --> exit()
#include <regstr.h>																		// Registry
#include <stdio.h>																		// Standard Input/Output
#include <time.h>																			// Timer

/***************************************************************************/

#include "custom.h"

/***************************************************************************/

//------------------------------------------------
#define PI											3.141592653589793238462643383279f
#define RADIAN_DEGREES					57.295779513082320876798154814114f
//------------------------------------------------

/***************************************************************************/

//! Moves current current angle towards destination depending on circle position
void		Angle_Adjust(float *current, float destination, float amount);

//! Returns 1 if angle1 is bigger, 2 if angle2 is bigger, and 0 if the same
int			Angle_Closer(float angle1, float angle2, float angleCompare);

//! Returns smallest angle difference between angles
float		Angle_Difference(float angle1, float angle2);

//! Returns whether angleCompare is between angles
bool		Angle_Inside(float angleBegin, float angleEnd, float angleCompare);

//! Returns the distance between the 2 points in 3D space
float		Calculate_Distance(float3 *current, float3 *destination);

//! Returns the distance between the 2 points in 2D space
float		Calculate_Distance_2D(float3 *current, float3 *destination);

//! Returns random number [0..upperLimit]
int			Calculate_Random(int upperLimit);

//! Returns the rotation based on the x axis (Pitch) [270.0f..90.0f]
float		Calculate_Rotation_x(float3 *base, float3 *point);

//! Returns the rotation based on the z axis (Yaw) [0.0f..360.0f]
float		Calculate_Rotation_z(float3 *base, float3 *point);

//! Clamps value [min..max]
template <class T>
void		Clamp(T *value, T min, T max, bool rollOver);

//! Returns closest point on line [point1, point2] from point3
float3	Closest_Point_2D(float3 *point1, float3 *point2, float3 *point3);

//! Calculates the cross product
float3	Cross_Product(float3 *value1, float3 *value2);

//! Calculates the dot product
float		Dot_Product(float3 *value1, float3 *value2);

//! Changes current by amount to try and reach goal (returns true if current was changed)
template <class T>
bool		Goal(T *current, T goal, T amount);

//! Draws triangle to screen (if not textured, set iTexture = -1)
void		Render_Triangle(int iTexture, float r, float g, float b, float transparency, float bottomLeftX, float bottomLeftY, float bottomLeftZ, float topRightX, float topRightY, float topRightZ, float topLeftX, float topLeftY, float topLeftZ, float bottomLeftPercentX = 0.0f, float bottomLeftPercentY = 0.0f, float topRightPercentX = 1.0f, float topRightPercentY = 1.0f, float topLeftPercentX = 0.0f, float topLeftPercentY = 1.0f);

//! Draws quad to screen (if not textured, set iTexture = -1)
void		Render_Quad(int iTexture, float r, float g, float b, float transparency, float bottomLeftX, float bottomLeftY, float bottomLeftZ, float bottomRightX, float bottomRightY, float bottomRightZ, float topRightX, float topRightY, float topRightZ, float topLeftX, float topLeftY, float topLeftZ, float bottomLeftPercentX = 0.0f, float bottomLeftPercentY = 0.0f, float bottomRightPercentX = 1.0f, float bottomRightPercentY = 0.0f, float topRightPercentX = 1.0f, float topRightPercentY = 1.0f, float topLeftPercentX = 0.0f, float topLeftPercentY = 1.0f);

//! Returns windows version (95, 98, Me, NT, 2000, XP, Server_2003, Vista, Windows_7)
CString	Retrieve_Windows_Version();

//! Rotates point around base on the x axis (Pitch)
void		Rotate_x(float3 *base, float3 *point, float amount);

//! Rotates point around base on the y axis (Roll)
void		Rotate_y(float3 *base, float3 *point, float amount);

//! Rotates point around base on the z axis (Yaw)
void		Rotate_z(float3 *base, float3 *point, float amount);

//! Scales point in reference to base point
void		Scale_Length(float3 *base, float3 *point, float amount);

/***************************************************************************/

template <class T>
void Clamp(T *value, T min, T max, bool rollOver)

{
	if (rollOver == true)
	{
		while (*value > max)
			*value = *value - (max - min);
		while (*value < 0.0f)
			*value = *value + (max - min);
	}
	else
	{
		if (*value > max)
			*value = max;
		else if (*value < min)
			*value = min;
	}
}

/***************************************************************************/

template <class T>
bool Goal(T *current, T goal, T amount)

{
	if (*current > goal)
	{
		*current = *current - amount;
		if (*current < goal)
			*current = goal;
		return (true);
	}
	else if (*current < goal)
	{
		*current = *current + amount;
		if (*current > goal)
			*current = goal;
		return (true);
	}

	return (false);
}

/***************************************************************************/

#include "object.h"
#include "physics.h"
#include "io_file.h"
#include "io_misc.h"
#include "io_pak.h"
#include "audio.h"
#include "camera.h"
#include "network.h"
#include "window.h"

/***************************************************************************/
#endif